<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ env('APP_NAME', 'School Software') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 min-h-screen flex items-center justify-center">

    <div class="max-w-4xl w-full p-6 bg-white shadow-lg rounded-2xl space-y-10">

        <h1 class="text-3xl font-bold text-gray-800 text-center">
            {{ env('APP_NAME', 'School Software') }} API Demo
        </h1>
        <p class="text-center text-gray-600">Encoded Payloads + Clickable Buttons</p>

        {{-- Student Vital --}}
        @php
            $payload = [
                'institute_id' => 1,
                'branch_id' => 5,
                'student_id' => 2,
            ];
            $encodedStudentVital = base64_encode(json_encode($payload));
        @endphp

        <div class="border p-4 rounded-xl shadow">
            <h2 class="text-xl font-semibold mb-2">🎓 Student Vital</h2>
            <pre class="bg-gray-100 p-3 rounded text-sm">{{ json_encode($payload, JSON_PRETTY_PRINT) }}</pre>
            <p class="mt-2 text-xs text-gray-500 break-all">Encoded: {{ $encodedStudentVital }}</p>
            <a href="{{ route('student-vital', $encodedStudentVital) }}" target="_blank"
                class="mt-3 inline-block bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                Open Vital
            </a>
        </div>

        {{-- Student ID Cards --}}
        @php
            $payload = [
                'class_id' => 1,
                'section_id' => 1,
                'group_id' => 1,
                'validity' => '2025-12-31',
                'institute_id' => 1,
                'branch_id' => 1,
            ];
            $encodedStudentCard = base64_encode(json_encode($payload));
        @endphp

        <div class="border p-4 rounded-xl shadow">
            <h2 class="text-xl font-semibold mb-2">🆔 Student ID Cards</h2>
            <pre class="bg-gray-100 p-3 rounded text-sm">{{ json_encode($payload, JSON_PRETTY_PRINT) }}</pre>
            <p class="mt-2 text-xs text-gray-500 break-all">Encoded: {{ $encodedStudentCard }}</p>
            <a href="{{ route('studentIdCardList', $encodedStudentCard) }}" target="_blank"
                class="mt-3 inline-block bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700">
                View Student ID Cards
            </a>
        </div>

        {{-- Teacher ID Cards --}}
        @php
            $payload = [
                'institute_id' => 1,
                'branch_id' => 1,
            ];
            $encodedTeacherCard = base64_encode(json_encode($payload));
        @endphp

        <div class="border p-4 rounded-xl shadow">
            <h2 class="text-xl font-semibold mb-2">👨‍🏫 Teacher ID Cards</h2>
            <pre class="bg-gray-100 p-3 rounded text-sm">{{ json_encode($payload, JSON_PRETTY_PRINT) }}</pre>
            <p class="mt-2 text-xs text-gray-500 break-all">Encoded: {{ $encodedTeacherCard }}</p>
            <a href="{{ route('teacherIdCardList', $encodedTeacherCard) }}" target="_blank"
                class="mt-3 inline-block bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700">
                View Teacher ID Cards
            </a>
        </div>

        {{-- Staff ID Cards --}}
        @php
            $payload = [
                'institute_id' => 1,
                'branch_id' => 1,
            ];
            $encodedStaffCard = base64_encode(json_encode($payload));
        @endphp

        <div class="border p-4 rounded-xl shadow">
            <h2 class="text-xl font-semibold mb-2">👩‍💼 Staff ID Cards</h2>
            <pre class="bg-gray-100 p-3 rounded text-sm">{{ json_encode($payload, JSON_PRETTY_PRINT) }}</pre>
            <p class="mt-2 text-xs text-gray-500 break-all">Encoded: {{ $encodedStaffCard }}</p>
            <a href="{{ route('staffIdCardList', $encodedStaffCard) }}" target="_blank"
                class="mt-3 inline-block bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700">
                View Staff ID Cards
            </a>
        </div>

    </div>

</body>

</html>
