<?php

namespace Modules\Quiz\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Quiz\Models\Question;

class QuestionFactory extends Factory
{
    protected $model = Question::class;

    public function definition(): array
    {
        return [
            'institute_id' => 1,
            'branch_id' => 1,
            'topic_id' => $this->faker->numberBetween(1, 10), // Create or assign a topic ID
            'question' => $this->faker->sentence(10), // Generate a question with 10 words
            'a' => $this->faker->word, // Option A
            'b' => $this->faker->word, // Option B
            'c' => $this->faker->word, // Option C
            'd' => $this->faker->word, // Option D
            'answer' => $this->faker->randomElement(['a', 'b', 'c', 'd']), // Random correct answer
            'code_snippet' => $this->faker->optional()->text(200), // Optional code snippet
            'answer_exp' => $this->faker->optional()->paragraph, // Optional answer explanation
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
