<?php

declare(strict_types=1);

namespace Modules\Payroll\Repositories;

use App\Interfaces\BaseRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Collection;
use Modules\Payroll\Models\Payment;

class PaymentRepository implements BaseRepositoryInterface
{
    public function all(): Collection
    {
        return Payment::all();
    }

    public function paginate(int $perPage = 100, array $filter = []): LengthAwarePaginator
    {
        $query = Payment::query();

        return $query->where('institute_id', get_institute_id())->where('branch_id', get_branch_id())->paginate($perPage);
    }

    public function create(array $data): ?Payment
    {
        return Payment::create($data);
    }

    public function update(array $data, int $id): mixed
    {
        return Payment::find($id)->update($data);
    }

    public function delete(int $id): int
    {
        return Payment::destroy($id);
    }

    public function show(int $id): ?Payment
    {
        return Payment::find($id);
    }
}
