<?php

namespace Modules\Authentication\Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class UtilitySeeder extends Seeder
{
    public function run()
    {
        // Default s_a_a_s_settings
        DB::table('s_a_a_s_settings')->insert([
            [
                'type' => 'general',
                'name' => 'site_name',
                'value' => 'SAAS Site',
            ],
            [
                'type' => 'general',
                'name' => 'site_title',
                'value' => 'SAAS Title',
            ],
            [
                'type' => 'general',
                'name' => 'phone',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'office_phone',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'email',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'language',
                'value' => 'en',
            ],
            [
                'type' => 'general',
                'name' => 'google_map',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'address',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'on_google_map',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'currency_symbol',
                'value' => '$',
            ],
            [
                'type' => 'general',
                'name' => 'logo',
                'value' => 'logo.png',
            ],
            [
                'type' => 'general',
                'name' => 'disabled_website',
                'value' => 'no',
            ],
            [
                'type' => 'general',
                'name' => 'copyright_text',
                'value' => '&copy; Copyright 2025. All Rights Reserved by FueDevs LTD',
            ],
            [
                'type' => 'general',
                'name' => 'facebook_link',
                'value' => 'https://www.facebook.com/',
            ],
            [
                'type' => 'general',
                'name' => 'google_plus_link',
                'value' => 'https://www.google.com/',
            ],
            [
                'type' => 'general',
                'name' => 'youtube_link',
                'value' => 'https://www.youtube.com/',
            ],
            [
                'type' => 'general',
                'name' => 'whats_app_link',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'twitter_link',
                'value' => 'https://www.twitter.com',
            ],
            [
                'type' => 'general',
                'name' => 'header_notice',
                'value' => '',
            ],
            [
                'type' => 'general',
                'name' => 'app_version',
                'value' => '1.0.0',
            ],
            [
                'type' => 'general',
                'name' => 'app_url',
                'value' => 'drive-link',
            ],
        ]);

        // Default s_a_a_s_settings
        DB::table('s_a_a_s_settings')->insert([
            // Payment Gateway
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'bkash',
                'payment_info' => json_encode([
                    'app_key' => '4f6o0cjiki2rfm34kfdadl1eqq',
                    'app_secret' => '2is7hdktrekvrbljjh44ll3d9l1dtjo4pasmjvs5vl5qr3fug4b',
                    'username' => 'sandboxTokenizedUser02',
                    'password' => 'sandboxTokenizedUser02@12345',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paystack',
                'payment_info' => json_encode([
                    'public_key' => 'pk_test_cdbf1367be2cde97517468c4752b0333525e88c2',
                    'secret_key' => 'sk_test_78934e683acd8b3fe7ae970f1b2b04ace0464873',
                    'merchant_email' => 'imdshariful171@gmail.com',
                    'callback_url' => 'https:\/\/api.paystack.co',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'razor_pay',
                'payment_info' => json_encode([
                    'api_key' => 'rzp_test_qqSoHq8CoqPkDQ',
                    'api_secret' => 'nYunmbLpeoNZZd3RbHgSe3cW',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'stripe',
                'payment_info' => json_encode([
                    'published_key' => 'pk_test_PYPVAZcZj6ismKW2kv2jACU900iAgMGCIb',
                    'api_key' => 'sk_test_bldfFddQARLRVTAJQPLeLWOH00hip4UNZF',
                    'mode' => 'test',
                    'other_config_key' => 'test_value',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'ssl_commerz',
                'payment_info' => json_encode([
                    'store_id' => 'custo5cc042f7abf4c',
                    'store_password' => 'custo5cc042f7abf4c@ssl',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'pvit',
                'payment_info' => json_encode([
                    'mc_tel_merchant' => '060234587',
                    'access_token' => 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.SnhhS251OU1JV1BYenJ6aUMxb1EvZWIyeXVWWFNhK05kZWJiU2lMVUFsN2pwa2Y1K1JpejFZZ25KaUQ1U2hyNUVZcWJ5QzF6L0tmd1lHOVFzK3NqK25WdkpBQm5NZDhqcUlSWjZ2eTFTdnIycE9lOFRDRm82VXY5eldvbkw3cXdwY3F5TW1Dc2JkeTQrbGMwdjB1dWdLNWJKdEJKSjZDZ1Nwb2tNU3dTV1RtTk5oa0hhZnVKVEkyb01CeWFvNDRHVDRXS01EaTMzRFZxSW5wV05YNXcxc2Nad1ZsQVRyRU1HTEYwOHpCVVlObk8waUxmeEI5d2FlbDdhWEZrWVFidTo6YzJ4YVpHKzlEMStoeUpVWG9mcUlWQT09.9yZOaT/zjc2xdW6k37O6qqp+4EzpSKJEwNNK06WXl0c=',
                    'mc_merchant_code' => 'RA5118',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paypal',
                'payment_info' => json_encode([
                    'client_id' => 'AabIbRZ97J0GHt0xf_DJj3u1dp6MU9boJGwnRY7OZ6fqBJVsrxd7PaBqqi6OGTYe2e4N4dWkYOkFSNtM',
                    'client_secret' => 'EIeb5GszxCqanj964p4HYBQ5HMx6TwUGedqY6zdfJqlV-TQMF-cgIP2kZP6d_ZgbS3qjiVJxQH1X6wPt',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paymob_accept',
                'payment_info' => json_encode([
                    'api_key' => 'ZXlKaGJHY2lPaUpJVXpVeE1pSXNJblI1Y0NJNklrcFhWQ0o5LmV5SnVZVzFsSWpvaU1UWTNOelE0TmpZNU1pNDNNemd6TURZaUxDSndjbTltYVd4bFgzQnJJam94Tmpjd01EWXNJbU5zWVhOeklqb2lUV1Z5WTJoaGJuUWlmUS5NRzFqMGp1WXVDLWt3NjAyMlhHcXJWSTB5aWNCNERrVlQzZndWd21HNEtIT3duS0hhVFBJWTdsU3JlaWtvazItYUNyOHlVVDZFdG14SGw4M3Yzd0dHZw==',
                    'integration_id' => '1974622',
                    'iframe_id' => '368299',
                    'hmac_secret' => '3E031CEDBA789C96F50692CA8E7261BA',
                    'supported_country' => 'EG',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'flutterwave',
                'payment_info' => json_encode([
                    'public_key' => 'LWPUBK_TEST-3f6a0b6c3d621c4ecbb9beeff516c92b-X',
                    'secret_key' => 'FLWSECK_TEST-ec27426eb062491500a9eb95723b5436-X',
                    'encryption_key' => 'FLWSECK_TEST951e36220f66',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'senang_pay',
                'payment_info' => json_encode([
                    'merchant_id' => 'test_merchant_001',
                    'secret_key' => 'test_secret_key_001',
                ]),
            ],
            [
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paytm',
                'payment_info' => json_encode([
                    'merchant_id' => 'test_mid_001',
                    'merchant_key' => 'test_key_001',
                    'merchant_website_link' => 'WEBSTAGING',
                    'refund_url' => 'https://securegw-stage.paytm.in/refund/apply',
                ]),
            ],
        ]);

        // Default Settings
        DB::table('settings')->insert([
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'school_name',
                'value' => 'Demo Collage',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'site_title',
                'value' => 'Demo Title',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'phone',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'email',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'language',
                'value' => 'en',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'google_map',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'address',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'on_google_map',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'institute_code',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'timezone',
                'value' => 'Asia/Dhaka',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'academic_year',
                'value' => '1',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'currency_symbol',
                'value' => '$',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'mail_type',
                'value' => 'mail',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'logo',
                'value' => 'logo.png',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'disabled_website',
                'value' => 'no',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'copyright_text',
                'value' => '&copy; Copyright 2025. All Rights Reserved by FueDevs LTD',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'exam_result_phone',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'tuition_fee_phone',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'facebook_link',
                'value' => 'https://www.facebook.com/',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'google_plus_link',
                'value' => 'https://www.google.com/',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'youtube_link',
                'value' => 'https://www.youtube.com/',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'whats_app_link',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'twitter_link',
                'value' => 'https://www.twitter.com',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'eiin_code',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'sms_gateway',
                'value' => 'twilio',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'bulk_sms_api_key',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'bulk_sms_sender_id',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'twilio_sid',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'twilio_token',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'twilio_from_number',
                'value' => '',
            ],

            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'zoom_account_id',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'zoom_client_key',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'zoom_client_secret',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'header_notice',
                'value' => '',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'exam_result_status',
                'value' => 'no',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'admission_display_status',
                'value' => 'no',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'tc_amount',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'primary_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'secondary_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'primary_container_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'dark_primary_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'dark_secondary_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'dark_container_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'text_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'dark_text_colo',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'sidebar_selected_bg_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'sidebar_selected_text_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'sidebar_selected_text_color',
                'value' => null,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'guidance',
                'value' => '01XXXXXXXXX',
            ],

            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'academic_office',
                'value' => '01XXXXXXXXX',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'tuition_fee',
                'value' => '01XXXXXXXXX',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'exam_office',
                'value' => '01XXXXXXXXX',
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'general',
                'name' => 'website_link',
                'value' => 'demo.com',
            ],
        ]);

        // Default Settings
        DB::table('settings')->insert([
            // Payment Gateway
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'bkash',
                'payment_info' => json_encode([
                    'app_key' => '4f6o0cjiki2rfm34kfdadl1eqq',
                    'app_secret' => '2is7hdktrekvrbljjh44ll3d9l1dtjo4pasmjvs5vl5qr3fug4b',
                    'username' => 'sandboxTokenizedUser02',
                    'password' => 'sandboxTokenizedUser02@12345',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paystack',
                'payment_info' => json_encode([
                    'public_key' => 'pk_test_cdbf1367be2cde97517468c4752b0333525e88c2',
                    'secret_key' => 'sk_test_78934e683acd8b3fe7ae970f1b2b04ace0464873',
                    'merchant_email' => 'imdshariful171@gmail.com',
                    'callback_url' => 'https:\/\/api.paystack.co',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'razor_pay',
                'payment_info' => json_encode([
                    'api_key' => 'rzp_test_qqSoHq8CoqPkDQ',
                    'api_secret' => 'nYunmbLpeoNZZd3RbHgSe3cW',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'stripe',
                'payment_info' => json_encode([
                    'published_key' => 'pk_test_PYPVAZcZj6ismKW2kv2jACU900iAgMGCIb',
                    'api_key' => 'sk_test_bldfFddQARLRVTAJQPLeLWOH00hip4UNZF',
                    'mode' => 'test',
                    'other_config_key' => 'test_value',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'ssl_commerz',
                'payment_info' => json_encode([
                    'store_id' => 'custo5cc042f7abf4c',
                    'store_password' => 'custo5cc042f7abf4c@ssl',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'pvit',
                'payment_info' => json_encode([
                    'mc_tel_merchant' => '060234587',
                    'access_token' => 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.SnhhS251OU1JV1BYenJ6aUMxb1EvZWIyeXVWWFNhK05kZWJiU2lMVUFsN2pwa2Y1K1JpejFZZ25KaUQ1U2hyNUVZcWJ5QzF6L0tmd1lHOVFzK3NqK25WdkpBQm5NZDhqcUlSWjZ2eTFTdnIycE9lOFRDRm82VXY5eldvbkw3cXdwY3F5TW1Dc2JkeTQrbGMwdjB1dWdLNWJKdEJKSjZDZ1Nwb2tNU3dTV1RtTk5oa0hhZnVKVEkyb01CeWFvNDRHVDRXS01EaTMzRFZxSW5wV05YNXcxc2Nad1ZsQVRyRU1HTEYwOHpCVVlObk8waUxmeEI5d2FlbDdhWEZrWVFidTo6YzJ4YVpHKzlEMStoeUpVWG9mcUlWQT09.9yZOaT/zjc2xdW6k37O6qqp+4EzpSKJEwNNK06WXl0c=',
                    'mc_merchant_code' => 'RA5118',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paypal',
                'payment_info' => json_encode([
                    'client_id' => 'AabIbRZ97J0GHt0xf_DJj3u1dp6MU9boJGwnRY7OZ6fqBJVsrxd7PaBqqi6OGTYe2e4N4dWkYOkFSNtM',
                    'client_secret' => 'EIeb5GszxCqanj964p4HYBQ5HMx6TwUGedqY6zdfJqlV-TQMF-cgIP2kZP6d_ZgbS3qjiVJxQH1X6wPt',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paymob_accept',
                'payment_info' => json_encode([
                    'api_key' => 'ZXlKaGJHY2lPaUpJVXpVeE1pSXNJblI1Y0NJNklrcFhWQ0o5LmV5SnVZVzFsSWpvaU1UWTNOelE0TmpZNU1pNDNNemd6TURZaUxDSndjbTltYVd4bFgzQnJJam94Tmpjd01EWXNJbU5zWVhOeklqb2lUV1Z5WTJoaGJuUWlmUS5NRzFqMGp1WXVDLWt3NjAyMlhHcXJWSTB5aWNCNERrVlQzZndWd21HNEtIT3duS0hhVFBJWTdsU3JlaWtvazItYUNyOHlVVDZFdG14SGw4M3Yzd0dHZw==',
                    'integration_id' => '1974622',
                    'iframe_id' => '368299',
                    'hmac_secret' => '3E031CEDBA789C96F50692CA8E7261BA',
                    'supported_country' => 'EG',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'flutterwave',
                'payment_info' => json_encode([
                    'public_key' => 'LWPUBK_TEST-3f6a0b6c3d621c4ecbb9beeff516c92b-X',
                    'secret_key' => 'FLWSECK_TEST-ec27426eb062491500a9eb95723b5436-X',
                    'encryption_key' => 'FLWSECK_TEST951e36220f66',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'senang_pay',
                'payment_info' => json_encode([
                    'merchant_id' => 'test_merchant_001',
                    'secret_key' => 'test_secret_key_001',
                ]),
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'type' => 'payment_config',
                'mode' => 'test',
                'status' => 1,
                'name' => 'paytm',
                'payment_info' => json_encode([
                    'merchant_id' => 'test_mid_001',
                    'merchant_key' => 'test_key_001',
                    'merchant_website_link' => 'WEBSTAGING',
                    'refund_url' => 'https://securegw-stage.paytm.in/refund/apply',
                ]),
            ],
        ]);

        $days = [
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'day' => 'SATURDAY',
                'is_active' => 1,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'day' => 'SUNDAY',
                'is_active' => 1,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'day' => 'MONDAY',
                'is_active' => 1,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'day' => 'TUESDAY',
                'is_active' => 1,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'day' => 'WEDNESDAY',
                'is_active' => 1,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'day' => 'THURSDAY',
                'is_active' => 1,
            ],
            [
                'institute_id' => 1,
                'branch_id' => 1,
                'day' => 'FRIDAY',
                'is_active' => 1,
            ],
        ];
        DB::table('class_days')->insert($days);

        $academicYears = [
            [
                'id' => 1,
                'session' => 2024,
                'year' => 2024 . '-' . 2025,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 2,
                'session' => 2025,
                'year' => 2025 . '-' . 2026,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 3,
                'session' => 2026,
                'year' => 2026 . '-' . 2027,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 4,
                'session' => 2027,
                'year' => 2027 . '-' . 2028,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];
        DB::table('academic_years')->insert($academicYears);

        // Payroll Accounting Mappings
        DB::table('payroll_accounting_mappings')->insert([
            'ledger_id' => 55,
            'fund_id' => 1,
            'created_at' => Carbon::now(),
        ]);
    }
}
