<?php

namespace Modules\Authentication\Database\Seeders;

use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Modules\Academic\Models\Staff;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;
use Modules\Authentication\Models\User;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    private $saasAdminPermissionList = [
        'dashboard',
        'system-admin',
        'master_configuration.system_settings',
        'master_configuration.database_backup',
        'master_configuration.institutes',
        'master_configuration.plans',
        'master_configuration.cms_control',
    ];

    private $superAdminPermissionList = [
        'dashboard',
        'system-admin',
        'student_information.student_index',
        'student_information.student_create',
        'student_information.student_edit',
        'student_information.student_delete',
        'student_information.student_status_change',
        'student_information.student_migration',
        'student_information.student_pullback',
        'student_information.migration_list',
        'student_information.all_student_list',
        'staff_information.teachers_index',
        'staff_information.teachers_create',
        'staff_information.teachers_edit',
        'staff_information.teachers_delete',
        'staff_information.teachers_status_change',
        'staff_information.staffs_index',
        'staff_information.staffs_create',
        'staff_information.staffs_edit',
        'staff_information.staffs_delete',
        'staff_information.staff_attendance_view',
        'staff_information.staff_attendance_create',
        'staff_information.staffs_report',
        'student_attendance.student_attendance_index',
        'student_attendance.student_attendance_create',
        'student_attendance.exam_attendance_index',
        'student_attendance.exam_attendance_schedule',
        'student_attendance.student_attendance_report',
        'student_attendance.student_absent_report',
        'academic_configuration.academic_session',
        'academic_configuration.shifts',
        'academic_configuration.classes',
        'academic_configuration.sections',
        'academic_configuration.groups',
        'academic_configuration.periods',
        'academic_configuration.subjects',
        'academic_configuration.subject_config',
        'academic_configuration.exams',
        'academic_configuration.student_categories',
        'academic_configuration.departments',
        'academic_configuration.picklist',
        'academic_configuration.principal_signatures',
        'fees_management.startup',
        'fees_management.mapping',
        'fees_management.amount_config',
        'fees_management.date_config',
        'fees_management.fine_waiver',
        'fees_management.waiver',
        'fees_management.waiver_config',
        'fees_management.smart_collection',
        'fees_management.paid_info',
        'fees_management.unpaid_info',
        'accounting_management.ledgers',
        'accounting_management.funds',
        'accounting_management.categories',
        'accounting_management.groups',
        'accounting_management.payment',
        'accounting_management.receipt',
        'accounting_management.contra',
        'accounting_management.journal',
        'accounting_management.fund_transfer',
        'accounting_management.chart_of_accounts',
        'accounting_report.balance_sheet',
        'accounting_report.trial_balance',
        'accounting_report.cash_flow_statement',
        'accounting_report.cash_flow_details',
        'accounting_report.cash_book_account',
        'accounting_report.ledger_book_account',
        'accounting_report.income_statement',
        'accounting_report.cash_summary',
        'payroll.payroll_start_up',
        'payroll.payroll_mapping',
        'payroll.payroll_assign',
        'payroll.salary_slip',
        'payroll.salary',
        'payroll.due',
        'payroll.advance',
        'payroll.return_advance_payment',
        'payroll.salary_statement',
        'payroll.payment_info',
        'routine_management.syllabuses',
        'routine_management.assignments',
        'routine_management.class_routine',
        'routine_management.exam_routine',
        'routine_management.admit_seat_plan',
        'library_management.book_category',
        'library_management.books',
        'library_management.members',
        'library_management.book_issue_search',
        'library_management.book_issue_report',
        'library_management.book_barcode_print',
        'exam_module.exam_start_up',
        'exam_module.mark_config',
        'exam_module.remarks_config',
        'exam_module.mark_input',
        'exam_module.exam_result',
        'layouts_certificates.general',
        'layouts_certificates.testimonial',
        'layouts_certificates.attendance_certificate',
        'layouts_certificates.hsc_recommendation_letter',
        'layouts_certificates.transfer',
        'layouts_certificates.abroad_letter',
        'sms_notifications.templates',
        'sms_notifications.phonebook_category',
        'sms_notifications.phonebook',
        'sms_notifications.sent_sms',
        'sms_notifications.purchase_sms',
        'sms_notifications.sms_report',
        'administrator.assign_shift',
        'administrator.assign_subject',
        'administrator.assign_class',
        'administrator.notice',
        'administrator.event',
        'administrator.contact_message',
        'administrator.user_activities',
        'quiz.topics',
        'quiz.questions',
        'quiz.answers',
        'quiz.all_reports',
        'master_configuration.system_settings',
        'master_configuration.roles',
        'master_configuration.users',
        'master_configuration.database_backup',
        'master_configuration.branches',
        'zoom-index',
        'zoom-create',
        'zoom-update',
        'zoom-delete',
        'payment_gateway.index',
        'payment_gateway.create',
        'payment_gateway.update',
        'payment_gateway.delete',
        'role-index',
        'role-create',
        'role-update',
        'role-delete',
        'user-index',
        'user-create',
        'user-update',
        'user-delete',
        'hostel_panel',
        'transport_panel',
    ];

    private $systemAdminPermissionList = [
        'dashboard',
        'system-admin',
        'student_information.student_index',
        'student_information.student_create',
        'student_information.student_edit',
        'student_information.student_delete',
        'student_information.student_status_change',
        'student_information.student_migration',
        'student_information.student_pullback',
        'student_information.migration_list',
        'student_information.all_student_list',
        'staff_information.teachers_index',
        'staff_information.teachers_create',
        'staff_information.teachers_edit',
        'staff_information.teachers_delete',
        'staff_information.teachers_status_change',
        'staff_information.staffs_index',
        'staff_information.staffs_create',
        'staff_information.staffs_edit',
        'staff_information.staffs_delete',
        'staff_information.staff_attendance_view',
        'staff_information.staff_attendance_create',
        'staff_information.staffs_report',
        'student_attendance.student_attendance_index',
        'student_attendance.student_attendance_create',
        'student_attendance.exam_attendance_index',
        'student_attendance.exam_attendance_schedule',
        'student_attendance.student_attendance_report',
        'student_attendance.student_absent_report',
        'academic_configuration.academic_session',
        'academic_configuration.shifts',
        'academic_configuration.classes',
        'academic_configuration.sections',
        'academic_configuration.groups',
        'academic_configuration.periods',
        'academic_configuration.subjects',
        'academic_configuration.subject_config',
        'academic_configuration.exams',
        'academic_configuration.student_categories',
        'academic_configuration.departments',
        'academic_configuration.picklist',
        'academic_configuration.principal_signatures',
        'routine_management.syllabuses',
        'routine_management.assignments',
        'routine_management.class_routine',
        'routine_management.exam_routine',
        'routine_management.admit_seat_plan',
        'library_management.book_category',
        'library_management.books',
        'library_management.members',
        'library_management.book_issue_search',
        'library_management.book_issue_report',
        'library_management.book_barcode_print',
        'exam_module.exam_start_up',
        'exam_module.mark_config',
        'exam_module.remarks_config',
        'exam_module.mark_input',
        'exam_module.exam_result',
        'layouts_certificates.general',
        'layouts_certificates.testimonial',
        'layouts_certificates.attendance_certificate',
        'layouts_certificates.hsc_recommendation_letter',
        'layouts_certificates.transfer',
        'layouts_certificates.abroad_letter',
        'sms_notifications.templates',
        'sms_notifications.phonebook_category',
        'sms_notifications.phonebook',
        'sms_notifications.sent_sms',
        'sms_notifications.purchase_sms',
        'sms_notifications.sms_report',
        'administrator.assign_shift',
        'administrator.assign_subject',
        'administrator.assign_class',
        'administrator.notice',
        'administrator.event',
        'administrator.contact_message',
        'administrator.user_activities',
        'quiz.topics',
        'quiz.questions',
        'quiz.answers',
        'quiz.all_reports',
        'master_configuration.system_settings',
        'master_configuration.roles',
        'master_configuration.users',
        'master_configuration.database_backup',
        'zoom-index',
        'zoom-create',
        'zoom-update',
        'zoom-delete',
        'payment_gateway.index',
        'payment_gateway.create',
        'payment_gateway.update',
        'payment_gateway.delete',
    ];

    private $accountantPermissionList = [
        'dashboard',
        'system-admin',
        'fees_management.startup',
        'fees_management.mapping',
        'fees_management.amount_config',
        'fees_management.date_config',
        'fees_management.fine_waiver',
        'fees_management.waiver',
        'fees_management.waiver_config',
        'fees_management.smart_collection',
        'fees_management.paid_info',
        'fees_management.unpaid_info',
        'accounting_management.ledgers',
        'accounting_management.funds',
        'accounting_management.categories',
        'accounting_management.groups',
        'accounting_management.payment',
        'accounting_management.receipt',
        'accounting_management.contra',
        'accounting_management.journal',
        'accounting_management.fund_transfer',
        'accounting_management.chart_of_accounts',
        'accounting_report.balance_sheet',
        'accounting_report.trial_balance',
        'accounting_report.cash_flow_statement',
        'accounting_report.cash_flow_details',
        'accounting_report.cash_book_account',
        'accounting_report.ledger_book_account',
        'accounting_report.income_statement',
        'accounting_report.cash_summary',
        'payroll.payroll_start_up',
        'payroll.payroll_mapping',
        'payroll.payroll_assign',
        'payroll.salary_slip',
        'payroll.salary',
        'payroll.due',
        'payroll.advance',
        'payroll.return_advance_payment',
        'payroll.salary_statement',
        'payroll.payment_info',
    ];

    private $librarianPermissionList = [
        'dashboard',
        'system-admin',
        'library_management.book_category',
        'library_management.books',
        'library_management.members',
        'library_management.book_issue_search',
        'library_management.book_issue_report',
        'library_management.book_barcode_print',
    ];

    private $teacherPermissionList = [
        'dashboard',
        'teacher_panel'
    ];

    private $studentPermissionList = [
        'dashboard',
        'student_panel'
    ];

    private $parentPermissionList = [
        'dashboard',
        'parent_panel'
    ];

    private $hostelPermissionList = [
        'dashboard',
        'hostel_panel'
    ];

    private $transportPermissionList = [
        'dashboard',
        'transport_panel'
    ];

    public function run(): void
    {
        Permission::updateOrCreate(['name' => 'master_configuration.institutes',  'guard_name' => 'web']);
        Permission::updateOrCreate(['name' => 'master_configuration.plans',  'guard_name' => 'web']);
        Permission::updateOrCreate(['name' => 'master_configuration.cms_control',  'guard_name' => 'web']);
        Permission::updateOrCreate(['name' => 'teacher_panel',  'guard_name' => 'web']);
        Permission::updateOrCreate(['name' => 'student_panel',  'guard_name' => 'web']);
        Permission::updateOrCreate(['name' => 'parent_panel',  'guard_name' => 'web']);
        Permission::updateOrCreate(['name' => 'hostel_panel',  'guard_name' => 'web']);
        Permission::updateOrCreate(['name' => 'transport_panel',  'guard_name' => 'web']);

        foreach ($this->superAdminPermissionList as $permission) {
            Permission::updateOrCreate(['name' => $permission,  'guard_name' => 'web']);
        }

        // Create roles with guard names
        $saasAdminRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'SAAS Admin', 'description' => 'This is SAAS-Admin role', 'guard_name' => 'web']);
        $superAdminRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Super Admin', 'description' => 'This is Super Admin role', 'guard_name' => 'web']);
        $systemAdminRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'System Admin', 'description' => 'This is System Admin role', 'guard_name' => 'web']);
        $accountantRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Accountant', 'description' => 'This is Accountant role', 'guard_name' => 'web']);
        $librarianRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Librarian', 'description' => 'This is Librarian role', 'guard_name' => 'web']);
        $teacherRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Teacher', 'description' => 'This is Teacher role', 'guard_name' => 'web']);
        $studentRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Student', 'description' => 'This is Student role', 'guard_name' => 'web']);
        $parentRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Parent', 'description' => 'This is Parent role', 'guard_name' => 'web']);
        $hostelRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Hostel', 'description' => 'This is Hostel role', 'guard_name' => 'web']);
        $transportRole = Role::updateOrCreate(['institute_id' => 1, 'branch_id' => 1, 'name' => 'Transport', 'description' => 'This is Transport role', 'guard_name' => 'web']);

        /* Assign Permissions to Roles */
        $saasAdminRole->syncPermissions($this->saasAdminPermissionList);
        $superAdminRole->syncPermissions($this->superAdminPermissionList);
        $systemAdminRole->syncPermissions($this->systemAdminPermissionList);
        $accountantRole->syncPermissions($this->accountantPermissionList);
        $librarianRole->syncPermissions($this->librarianPermissionList);
        $teacherRole->syncPermissions($this->teacherPermissionList);
        $studentRole->syncPermissions($this->studentPermissionList);
        $parentRole->syncPermissions($this->parentPermissionList);
        $hostelRole->syncPermissions($this->hostelPermissionList);
        $transportRole->syncPermissions($this->transportPermissionList);

        /** Now Create User */
        $this->createUser($saasAdminRole, 'SAAS Admin', 'saasadmin@gmail.com', '000000000001', '12345678', 'SAAS Admin');
        $this->createUser($superAdminRole, 'Super Admin', 'superadmin@gmail.com', '000000000002', '12345678', 'Super Admin');
        $this->createUser($systemAdminRole, 'System Admin', 'systemadmin@gmail.com', '000000000003', '12345678', 'System Admin');
        // $this->createUser($accountantRole, 'Accountant', 'accountant@gmail.com', '000000000004', '12345678', 'Accountant');
        // $this->createUser($librarianRole, 'Librarian', 'librarian@gmail.com', '000000000005', '12345678', 'Librarian');
        // $this->createUser($hostelRole, 'Hostel', 'hostel@gmail.com', '000000000006', '12345678', 'Hostel');
        // $this->createUser($transportRole, 'Transport', 'transport@gmail.com', '000000000007', '12345678', 'Transport');
    }

    public function createUser(Role $role, string $name, string $email, string $phone, string $password, $type)
    {
        $user = User::factory([
            'institute_id' => 1,
            'branch_id' => 1,
            'name' => $name,
            'email' => $email,
            'password' => Hash::make($password),
            'phone' => $phone,
            'user_type' => $type,
            'role_id' => $role->id,
            'remember_token' => Str::random(10),
            'platform' => 'WEB',
            'email_verified_at' => Carbon::now(),
            'last_active_time' => Carbon::now(),
            'status' => 1,
            'user_status' => 1,
            'image' => '5.png',
        ])->create();

        /* Get all the permission and assign admin role */
        $user->assignRole([$role->id]);
    }
}
