<?php

namespace Modules\Authentication\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class EmailVerificationNotificationController extends Controller
{
    /**
     * Send a new email verification notification.
     */
    public function store(Request $request): JsonResponse
    {
        if ($request->user()->hasVerifiedEmail()) {
            return $this->responseSuccess([], 'verified.');
        }

        $request->user()->sendEmailVerificationNotification();

        return $this->responseSuccess([], 'verification-link-sent.');
    }
}
