<?php

namespace Modules\Academic\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ExamTableSeeder extends Seeder
{
    public function run()
    {
        $exams = [
            ['name' => '1st Semester', 'exam_code' => '00001'],
            ['name' => '2nd Semester', 'exam_code' => '00002'],
            ['name' => 'Final Exam', 'exam_code' => '00003'],
            ['name' => 'Midterm Exam', 'exam_code' => '00004'],
            ['name' => '1st Term', 'exam_code' => '00005'],
            ['name' => '2nd Term', 'exam_code' => '00006'],
            ['name' => '3rd Term', 'exam_code' => '00007'],
            ['name' => 'Annual Exam', 'exam_code' => '00008'],
            ['name' => 'Quarterly Exam', 'exam_code' => '00009'],
            ['name' => 'End-of-Term Exam', 'exam_code' => '00010'],
            ['name' => 'Final Assessment', 'exam_code' => '00011'],
            ['name' => 'Term-End Exam', 'exam_code' => '00012'],
            ['name' => 'Sessional Exam', 'exam_code' => '00013'],
            ['name' => 'Monthly Test', 'exam_code' => '00014'],
        ];

        $branches = [1]; // Branch 1 and Branch 2
        foreach ($branches as $branch_id) {
            foreach ($exams as $exam) {
                DB::table('exams')->insert([
                    'session_id' => 1,
                    'institute_id' => 1,
                    'branch_id' => $branch_id,
                    'name' => $exam['name'],
                    'exam_code' => $exam['exam_code'],
                    'status' => 1,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
